/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;

public class TextLineNumber
extends JPanel
implements CaretListener,
DocumentListener,
PropertyChangeListener {
    private static final long serialVersionUID = 5602715425740593658L;
    private static final float RIGHT = 1.0f;
    private static final Border OUTER = new MatteBorder(0, 0, 0, 2, Color.GRAY);
    private static final int HEIGHT = 2146483647;
    private JTextComponent component;
    private JLabel lblLineNo;
    private JLabel lblColNo;
    private boolean updateFont;
    private int borderGap;
    private float digitAlignment;
    private int minimumDisplayDigits;
    private int lastDigits;
    private int lastHeight;
    private HashMap<String, FontMetrics> fonts;

    private TextLineNumber(JTextComponent component, JLabel l, JLabel c) {
        this(component, 3);
        this.lblLineNo = l;
        this.lblColNo = c;
    }

    private TextLineNumber(JTextComponent component, int minimumDisplayDigits) {
        this.component = component;
        this.setBackground(Color.white);
        this.setForeground(new Color(0, 128, 128));
        this.setFont(component.getFont());
        this.setBorderGap(5);
        this.setDigitAlignment(1.0f);
        this.setMinimumDisplayDigits(minimumDisplayDigits);
        component.getDocument().addDocumentListener(this);
        component.addCaretListener(this);
        component.addPropertyChangeListener("font", this);
    }

    private void setBorderGap(int borderGap) {
        this.borderGap = borderGap;
        EmptyBorder inner = new EmptyBorder(0, borderGap, 0, borderGap);
        this.setBorder(new CompoundBorder(OUTER, inner));
        this.lastDigits = 0;
        this.setPreferredWidth();
    }

    private void setDigitAlignment(float digitAlignment) {
        this.digitAlignment = digitAlignment > 1.0f ? 1.0f : (digitAlignment < 0.0f ? -1.0f : digitAlignment);
    }

    private void setMinimumDisplayDigits(int minimumDisplayDigits) {
        this.minimumDisplayDigits = minimumDisplayDigits;
        this.setPreferredWidth();
    }

    private void setPreferredWidth() {
        Element root = this.component.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = Math.max(String.valueOf(lines).length(), this.minimumDisplayDigits);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            d.setSize(preferredWidth, 2146483647);
            this.setPreferredSize(d);
            this.setSize(d);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
        Insets insets = this.getInsets();
        int availableWidth = this.getSize().width - insets.left - insets.right;
        Rectangle clip = g.getClipBounds();
        int rowStartOffset = this.component.viewToModel(new Point(0, clip.y));
        int endOffset = this.component.viewToModel(new Point(0, clip.y + clip.height));
        while (rowStartOffset <= endOffset) {
            try {
                String lineNumber = this.getTextLineNumber(rowStartOffset);
                int stringWidth = fontMetrics.stringWidth(lineNumber);
                int x = this.getOffsetX(availableWidth, stringWidth) + insets.left;
                int y = this.getOffsetY(rowStartOffset, fontMetrics);
                g.drawString(lineNumber, x, y);
                rowStartOffset = Utilities.getRowEnd(this.component, rowStartOffset) + 1;
            }
            catch (Exception exception) {}
        }
    }

    private String getTextLineNumber(int rowStartOffset) {
        int index;
        Element root = this.component.getDocument().getDefaultRootElement();
        Element line = root.getElement(index = root.getElementIndex(rowStartOffset));
        if (line.getStartOffset() == rowStartOffset) {
            return String.valueOf(index + 1);
        }
        return "";
    }

    private int getOffsetX(int availableWidth, int stringWidth) {
        return (int)((float)(availableWidth - stringWidth) * this.digitAlignment);
    }

    private int getOffsetY(int rowStartOffset, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle r = this.component.modelToView(rowStartOffset);
        int lineHeight = fontMetrics.getHeight();
        int y = r.y + r.height;
        int descent = 0;
        if (r.height == lineHeight) {
            descent = fontMetrics.getDescent();
        } else {
            if (this.fonts == null) {
                this.fonts = new HashMap();
            }
            Element root = this.component.getDocument().getDefaultRootElement();
            int index = root.getElementIndex(rowStartOffset);
            Element line = root.getElement(index);
            for (int i = 0; i < line.getElementCount(); ++i) {
                Element child = line.getElement(i);
                AttributeSet as = child.getAttributes();
                String fontFamily = (String)as.getAttribute(StyleConstants.FontFamily);
                Integer fontSize = (Integer)as.getAttribute(StyleConstants.FontSize);
                String key = fontFamily + fontSize;
                FontMetrics fm = this.fonts.get(key);
                if (fm == null) {
                    Font font = new Font(fontFamily, 0, fontSize);
                    fm = this.component.getFontMetrics(font);
                    this.fonts.put(key, fm);
                }
                descent = Math.max(descent, fm.getDescent());
            }
        }
        return y - descent;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int caretPos = this.component.getCaretPosition();
        int rowNum = caretPos == 0 ? 1 : 0;
        try {
            int offset = caretPos;
            while (offset > 0) {
                offset = Utilities.getRowStart(this.component, offset) - 1;
                ++rowNum;
            }
            this.lblLineNo.setText("Ln: " + rowNum);
            offset = Utilities.getRowStart(this.component, caretPos);
            int colNum = caretPos - offset + 1;
            this.lblColNo.setText("Col: " + colNum);
        }
        catch (BadLocationException exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    private void documentChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int preferredHeight = ((TextLineNumber)TextLineNumber.this).component.getPreferredSize().height;
                if (TextLineNumber.this.lastHeight != preferredHeight) {
                    TextLineNumber.this.setPreferredWidth();
                    TextLineNumber.this.repaint();
                    TextLineNumber.this.lastHeight = preferredHeight;
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof Font) {
            if (this.updateFont) {
                Font newFont = (Font)evt.getNewValue();
                this.setFont(newFont);
                this.lastDigits = 0;
                this.setPreferredWidth();
            } else {
                this.repaint();
            }
        }
    }
}

